#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#define N_JUG 10
#define N_SEVER 10

// VREME POTREBNO VOZILIMA DA PREDJU NADVOZNJAK

#define SLEEP_AUTO 1
#define SLEEP_AUTOBUS 2
#define SLEEP_KAMION 3

#define UKUPNO N_JUG+N_SEVER

#define JUG 2
#define SEVER 1
#define NEMA_NIKOGA 0

pthread_mutex_t mutex;
pthread_cond_t cond;

int smer = NEMA_NIKOGA;// 0 - Nema nikoga, SEVER - 1, JUG - 2

int automobilCounter = 0; // Broj automobila na nadvoznjaku
int autobusFlag = 0;// Flag da li ima autobusa na nadvoznjaku
int kamionFlag = 0;// Flag da li ima kamiona na nadvoznjaku

//srand(101);

void *predjiNadvoznjakSever(void *id){

    long idVozila = (long) id;

    int tipVozila = rand()%3;

    sleep(rand()%10);

    if(tipVozila == 0){ // AUTOMOBIL

        printf("Ja sam vozilo %ld TIPA : AUTOMOBIL , dolazim do nadvoznjaka iz smera : SEVER\n",idVozila);

        int autoCt;

        pthread_mutex_lock(&mutex);

        while(smer == JUG || kamionFlag == 1) pthread_cond_wait(&cond,&mutex);

        autoCt = ++automobilCounter;
        smer = SEVER;

        pthread_mutex_unlock(&mutex);

        printf("Ja sam vozilo %ld TIPA : AUTOMOBIL , prelazim nadvoznjak iz smera : SEVER. Broj automobila koji prelaze nadvoznjak: %d\n",idVozila,autoCt);
        sleep(SLEEP_AUTO);

        pthread_mutex_lock(&mutex);

        automobilCounter--;
        if(automobilCounter == 0 && autobusFlag == 0){
            smer = NEMA_NIKOGA;
        }

        pthread_cond_broadcast(&cond);

        printf("Ja sam vozilo %ld TIPA : AUTOMOBIL , presao sam nadvoznjak iz smera : SEVER\n",idVozila);

        pthread_mutex_unlock(&mutex);

        

    }
    else if(tipVozila == 1){ // AUTOBUS

        printf("Ja sam vozilo %ld TIPA : AUTOBUS , dolazim do nadvoznjaka iz smera : SEVER\n",idVozila);

        pthread_mutex_lock(&mutex);

        int brAutobusa;

        while(smer == JUG || autobusFlag == 1 || kamionFlag == 1) pthread_cond_wait(&cond,&mutex);

        autobusFlag = 1;
        brAutobusa = autobusFlag;
        smer = SEVER;

        pthread_mutex_unlock(&mutex);

        printf("Ja sam vozilo %ld TIPA : AUTOBUS , prelazim nadvoznjak iz smera : SEVER. Broj autobusa koji prelaze nadvoznjak: %d\n",idVozila,brAutobusa);
        sleep(SLEEP_AUTOBUS);

        pthread_mutex_lock(&mutex);

        autobusFlag = 0;
        if(automobilCounter == 0 && autobusFlag == 0)
            smer = NEMA_NIKOGA;

        pthread_cond_broadcast(&cond);

        printf("Ja sam vozilo %ld TIPA : AUTOBUS , presao sam nadvoznjak iz smera : SEVER\n",idVozila);

        pthread_mutex_unlock(&mutex);

        

    }
    else{ // KAMION

        int kamionCt;

        printf("Ja sam vozilo %ld TIPA : AUTOBUS , dolazim do nadvoznjaka iz smera : SEVER\n",idVozila);

        pthread_mutex_lock(&mutex);

        while(smer == JUG ||  automobilCounter > 0 || autobusFlag == 1 || kamionFlag == 1) pthread_cond_wait(&cond,&mutex);

        kamionFlag = 1;
        kamionCt = kamionFlag;
        smer = SEVER;

        pthread_mutex_unlock(&mutex);

        printf("Ja sam vozilo %ld TIPA : KAMION , prelazim nadvoznjak iz smera : SEVER. Broj kamiona koji prelaze nadvoznjak: %d\n",idVozila,kamionCt);
        sleep(SLEEP_KAMION);

        pthread_mutex_lock(&mutex);

        kamionFlag = 0;
        smer = NEMA_NIKOGA;

        pthread_cond_broadcast(&cond);

        printf("Ja sam vozilo %ld TIPA : KAMION , presao sam nadvoznjak iz smera : SEVER\n",idVozila);

        pthread_mutex_unlock(&mutex);

        

    }

    pthread_exit(NULL);


}

void *predjiNadvoznjakJug(void *id){

    long idVozila = (long) id;

    int tipVozila = rand()%3;

    sleep(rand()%10);

    if(tipVozila == 0){ // AUTOMOBIL

        int autoCt;

        printf("Ja sam vozilo %ld TIPA : AUTOMOBIL , dolazim do nadvoznjaka iz smera : JUG\n",idVozila);

        pthread_mutex_lock(&mutex);

        while(smer == SEVER || kamionFlag == 1) pthread_cond_wait(&cond,&mutex);

        autoCt = ++automobilCounter;
        smer = JUG;

        pthread_mutex_unlock(&mutex);

        printf("Ja sam vozilo %ld TIPA : AUTOMOBIL , prelazim nadvoznjak iz smera : JUG. Broj automobila koji prelaze nadvoznjak: %d\n",idVozila,autoCt);
        sleep(SLEEP_AUTO);

        pthread_mutex_lock(&mutex);

        automobilCounter--;
        if(automobilCounter == 0 && autobusFlag == 0){
            smer = NEMA_NIKOGA;
        }

        pthread_cond_broadcast(&cond);

        printf("Ja sam vozilo %ld TIPA : AUTOMOBIL , presao sam nadvoznjak iz smera : JUG\n",idVozila);

        pthread_mutex_unlock(&mutex);

        

    }
    else if(tipVozila == 1){ // AUTOBUS

        printf("Ja sam vozilo %ld TIPA : AUTOBUS , dolazim do nadvoznjaka iz smera : JUG\n",idVozila);

        pthread_mutex_lock(&mutex);

        int brAutobusa;

        while(smer == SEVER || autobusFlag == 1 || kamionFlag == 1) pthread_cond_wait(&cond,&mutex);

        autobusFlag = 1;
        brAutobusa = autobusFlag;
        smer = JUG;

        pthread_mutex_unlock(&mutex);

        printf("Ja sam vozilo %ld TIPA : AUTOBUS , prelazim nadvoznjak iz smera : JUG. Broj autobusa koji prelaze nadvoznjak: %d\n",idVozila,brAutobusa);
        sleep(SLEEP_AUTOBUS);

        pthread_mutex_lock(&mutex);

        autobusFlag = 0;
        if(automobilCounter == 0 && autobusFlag == 0)
            smer = NEMA_NIKOGA;

        pthread_cond_broadcast(&cond);
        
        printf("Ja sam vozilo %ld TIPA : AUTOBUS , presao sam nadvoznjak iz smera : JUG\n",idVozila);

        pthread_mutex_unlock(&mutex);

        

    }
    else{ // KAMION

        int kamionCt;

        printf("Ja sam vozilo %ld TIPA : KAMION , dolazim do nadvoznjaka iz smera : JUG\n",idVozila);

        pthread_mutex_lock(&mutex);

        while(smer == SEVER ||  automobilCounter > 0 || autobusFlag == 1 || kamionFlag == 1) pthread_cond_wait(&cond,&mutex);

        kamionFlag = 1;
        kamionCt = kamionFlag;
        smer = JUG;

        pthread_mutex_unlock(&mutex);

        printf("Ja sam vozilo %ld TIPA : KAMION , prelazim nadvoznjak iz smera : JUG. Broj kamiona koji prelaze nadvoznjak: %d\n",idVozila,kamionCt);
        sleep(SLEEP_KAMION);

        pthread_mutex_lock(&mutex);

        kamionFlag = 0;
        smer = NEMA_NIKOGA;

        pthread_cond_broadcast(&cond);

        printf("Ja sam vozilo %ld TIPA : KAMION , presao sam nadvoznjak iz smera : JUG\n",idVozila);

        pthread_mutex_unlock(&mutex);

        

    }

    pthread_exit(NULL);

}

int main(){

    pthread_t vozilo[UKUPNO];

    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&cond,NULL);
    //pthread_cond_init(&condAuto,NULL);
    //pthread_cond_init(&condAutobus,NULL);
    //pthread_cond_init(&condKamion,NULL);

    for(long i = 0;i<N_SEVER;i++){
        pthread_create(&vozilo[i],NULL,predjiNadvoznjakSever,(void *)i);       
    }

    for(long i = N_SEVER;i<UKUPNO;i++){
        pthread_create(&vozilo[i],NULL,predjiNadvoznjakJug,(void *)i);       
    }

    for(long i = 0;i<UKUPNO;i++)
        pthread_join(vozilo[i],NULL);

    return 0;

}